C     ---------------------------------------------------------------------ADDR
      subroutine addr (f,fr,neq)
      double precision f(1),fr(1)
c
      do 100 i=1,neq
         f(i)=f(i)+fr(i)
  100 continue
      return
      end
c     ------------------------------------------------------------------COPYI
      subroutine copyi (ia,ib,nsize)
      dimension ia(1),ib(1)
c.....This subroutine copies integer data from one address to the other of the
c.....global stoarge for compaction purpose.
      do 100 k=1,nsize
         ia(k)=ib(k)
  100 continue
      return
      end
C     ------------------------------------------------------------------COPYR
      subroutine copyr (a,b,nsize)
      implicit double precision (a-h,o-z)
      dimension a(1),b(1)
c
c.....This subroutine copies real data from one address to the other of the
c     global stoarge for compaction purpose.
c
      do 100 k=1,nsize
         a(k)=b(k)
  100 continue
      return
      end
C     ------------------------------------------------------------------COPRR
      subroutine coprr (a,b,nsize)
      implicit double precision (a-h,o-z)
      dimension a(1),b(1)
c
c.....This subroutine copies real data from one address to the other of the
c     global storage for compaction purpose.
c
      do 100 k=1,nsize
         b(k)=a(k)
  100 continue
      return
      end
C     --------------------------------------------------------------------COPR
      subroutine copr (a,b,nsize)
      implicit double precision (a-h,o-z)
      dimension a(1),b(1)
c.....This subroutine copies real data from one matrix to the other
      do 100 k=1,nsize
         b(k)=a(k)
  100 continue
      return
      end
c     ------------------------------------------------------------------ASSMK0
      subroutine assmk0 (iadres,s,lmdat,ekdat,icrack)
      implicit double precision (a-h,o-z)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      dimension iadres(1),s(1),lm(8),ek(64),ekb(36),lmdat(1),ekdat(1)
c
c     This subroutine assembles the element stiffness matrices from the disk
c     to the global array
c                                         Sudip S.B./McGill/Sept. 7, 1992
c
      if (icrack .ne. 0) then
         call assemk (iadres,s,lmdat,ekdat)
         return
      endif
      call izero (s(1),2*nsto)
      kdof=8
      do 500 n=1,numel
         read (nsp,rec=n) lm,ek
         call bigk (lm,ek,iadres,s,neq,kdof)
  500 continue
      if (nbms .eq. 0) return
      kdof=6
      do 600 n=1,nbms
         ncard=numel+n
         read (nsp,rec=ncard) lm,ekb
         call bigk (lm,ekb,iadres,s,neq,kdof)
  600 continue
c
      return
      end
c     ------------------------------------------------------------------ASSEMK
      subroutine assemk (iadres,s,lmdat,ekdat)
      implicit double precision (a-h,o-z)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      dimension iadres(1),s(1),lm(8),ek(64),lmdat(8,1),ekdat(64,1)
c
c     This subroutine assembles the element stiffness matrices from the core
c     to global array
c                                         Sudip S.B./McGill/Sept. 7, 1992
      call izero (s(1),2*nsto)
      if (nbms .eq. 0) go to 210
      do 200 n=1,nbms
         call copyi (lm,lmdat(1,n),6)
         call coprr (ekdat(1,n),ek,36)
         call bigk (lm,ek,iadres,s,neq,6)
  200 continue
  210 continue
      do 300 n=1,numel
         kdat=nbms+n
         call copyi (lm,lmdat(1,kdat),8)
         call coprr (ekdat(1,kdat),ek,64)
         call bigk (lm,ek,iadres,s,neq,8)
  300 continue
c
      return
      end
c     --------------------------------------------------------------------BIGK
      subroutine bigk (lm,ek,iadres,s,neq,kdof)
      implicit double precision (a-h,o-z)
      dimension lm(kdof),ek(kdof,kdof),iadres(1),s(1)
c
      do 200 j=1,kdof
         jj=lm(j)
         if (jj .gt. neq) go to 200
         do 100 i=1,kdof
            ii=lm(i)
            if (ii .gt. neq  .or. ii .gt. jj) go to 100
            if (ii .eq. jj) then
               iloc=iadres(ii)
               s(iloc)=s(iloc)+ek(i,j)
               go to 100
            else
               continue
            endif
            itop=iadres(jj-1)+1
            noff=iadres(jj)-itop
            iloc=itop+ii-(jj-noff)
            s(iloc)=s(iloc)+ek(i,j)
  100    continue
  200 continue
c
      return
      end
c     ------------------------------------------------------------------OPTSOL
      subroutine optsol (a,b,na,neq,jcol,jrow,kex)
      implicit double precision (a-h,o-z)
c
c     Solution routine for variable band storage. Adpated from ANSR.
c
      dimension a(1),b(neq),na(neq)
      data zero /0.0d0/
c
c
      neqq=neq-1
      go to (10,150,10), kex
c
c.....reduce coefficient matrix a
c
   10 if (neq.eq.1) return
      jf=max0(jcol,2)
      j1=jf+1
      il=jf-1
      jrw=jrow-1
      najp=na(il)
      do 140 j=jf,neq
      naj=na(j)
      if=j1-naj+najp
      if (if.ge.j) go to 130
      if1=max0(if+1,jrow)
      jk=naj-j
      if (if1.gt.il) go to 80
      jia=jk+if1
      i1=if1+1
      kl=if1-1
      naip=na(kl)
      do 70 i=if1,il
      nai=na(i)
      ik=nai-i
      ii=i1-nai+naip
      if (ii.ge.i) go to 60
      kf=max0(ii,if)
      jka=jk+kf
      ika=ik+kf
      aa=a(jia)
      if (kf.ge.jrow) go to 30
      do 20 k=kf,jrw
      nak=na(k)
      aa=aa-a(jka)*a(ika)*a(nak)
      jka=jka+1
   20 ika=ika+1
      if (jrow.gt.kl) go to 50
      kf=jrow
c
   30 do 40 k=kf,kl
      aa=aa-a(jka)*a(ika)
      jka=jka+1
   40 ika=ika+1
   50 a(jia)=aa
   60 jia=jia+1
      i1=i1+1
      kl=kl+1
   70 naip=nai
c
   80 kf=if
      jka=jk+if
      aa=a(naj)
      if (if.ge.jrow) go to 100
      do 90 k=if,jrw
      nai=na(k)
      aa=aa-a(nai)*a(jka)**2
   90 jka=jka+1
      if (jrow.gt.il) go to 120
      kf=jrow
c
  100 do 110 k=kf,il
      nai=na(k)
      cc=a(jka)/a(nai)
      aa=aa-a(jka)*cc
      a(jka)=cc
  110 jka=jka+1
  120 a(naj)=aa
  130 il=il+1
      j1=j1+1
  140 najp=naj
c
      go to (250,250,150), kex
c
c.....reduce vector b and back substitute
c
  150 if (neq.ne.1) go to 155
      b(1) = b(1)/a(1)
      return
  155 do 160 n=1,neqq
      if (b(n).ne.zero) go to 170
  160 continue
      n=neqq
  170 n1=n+1
      i1=n1+1
      kl=n
      naip=na(n)
      do 200 i=n1,neq
      nai=na(i)
      ii=i1-nai+naip
      if (ii.ge.i) go to 190
      kf=max0(ii,n)
      ik=nai-i
      ika=ik+kf
      bb=b(i)
      do 180 k=kf,kl
      bb=bb-a(ika)*b(k)
  180 ika=ika+1
      b(i)=bb
  190 i1=i1+1
      kl=kl+1
  200 naip=nai
      do 210 i=n,neq
      nai=na(i)
  210 b(i)=b(i)/a(nai)
c
c
      j=neq
      j1=j+1
      kl=neqq
      naj=na(neq)
      do 240 i=1,neqq
      najp=na(j-1)
      ii=j1-naj+najp
      if (ii.ge.j) go to 230
      jk=naj-j
      kf=ii
      jka=jk+kf
      bb=b(j)
      do 220 k=kf,kl
      b(k)=b(k)-a(jka)*bb
  220 jka=jka+1
  230 j1=j1-1
      kl=kl-1
      j=j-1
  240 naj=najp
c
  250 return
      end
c     -------------------------------------------------------------------DISPN
      subroutine dispn (numdof,tdisp,disp,numnp)
c      implicit double precision (a-h,o-z)
      double precision tdisp(1)
      dimension numdof(3,1),disp(2,1)
c
c.....This routine assembles the displcement vector from equation
c     number address to the nodal address
c
c                              Sudip S. Bhattacharjee/November 27,1991/McGill
c
      do 100 n=1,numnp
         disp(1,n)=tdisp(numdof(1,n))
         disp(2,n)=tdisp(numdof(2,n))
  100 continue
c
      return
      end
c     --------------------------------------------------------------------SAVE
      subroutine save (f,fr,eres,dummy,ndof,time)
c      implicit double precision (a-h,o-z)
      double precision f(1),fr(1),eres(4,1),time
      dimension dummy(2,1),ndof(1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c.....Save the nodal displacements and restoring forces (or accelerations), and element stresses
c.....  and element stresses at the current time
c
c                                    
c
c     Rotational dof are not saved.                 
c
	call outp(s,p)
	if (s .eq. 0) then 
	   return
	end if
 	write(not,10)
	write(ntm,10)
	call nopen(-nt7,'rsp')
      write(nt7,20)
	tt=time
      write (nt7,50) tt
      call dispn (ndof,f,dummy,numnp)
      write(nt7,60)
	write (nt7,1000)
	write(nt7,100)
	do i=1,numnp
	   write(nt7,1001)i
	   do j=1,2
	      write(nt7,1002)dummy(j,i)
	   end do
	end do
	call dispn (ndof,fr,dummy,numnp)
      write(nt7,70)
	write (nt7,2000)
	write(nt7,100)
	do i=1,numnp
	   write(nt7,1001)i
	   do j=1,2
	      write(nt7,1002)dummy(j,i)
	   end do
	end do
      write(nt7,80)
	write (nt7,3000)
	write(nt7,200)
	do i=1,numel
	   write(nt7,1001)i
	   do j=1,3
	      write(nt7,3001)eres(j,i)
	   end do
	   sx=eres(1,i)
	   sy=eres(2,i)
	   txy=eres(3,i)
	   smax=(sx+sy)/2+sqrt(((sx-sy)/2)**2+txy**2)
	   smin=(sx+sy)/2-sqrt(((sx-sy)/2)**2+txy**2)
	   write(nt7,3001)smin
	   write(nt7,3001)smax	
	end do
	close(nt7)
c
10	format(//,'        GOING TO SAVE THE RESPONSE OF STRUCTURE',/,
     +' File *.rsp contains response of structure')
20	format('******** RESPONSE OF STRUCTURE ********',//)
50	format('RESPONSE AT TIME: ',F5.2)
60	format(//,' -------- NODAL DISPLACEMENTS ---------')
70	format(////,' --------- RESTORING FORCES -----------')
80	format(////,' ----------------------------------- ELEMENT STRESSES 
     +------------------------------------')
100	format(' --------------------------------------',\)
200	format(' -------------------------------------------------------
     +----------------------------------',\)
1000	format(' NODE',10X,'UX',15X,'UY')
1001	format(/,I5,\)
1002	format(2X,E15.4,\)
2000	format(' NODE',10X,'FX',15X,'FY')
3000	format(' ELEMENT',5X,'SIGMA-X',10X,'SIGMA-Y',10X,'SIGMA-XY',8X,
     +'SIGMA-MIN',8X,'SIGMA-MAX')
3001	format(2X,E15.4,\)

      return
      end
c--------------------------------------------------------------------------TECPLOT	
	subroutine tecplot(coord,iele,stres)
      implicit double precision (a-h,o-z)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      dimension coord(2,1),iele(5,1),stres(4,1)
c
c.....Prepare input data file for TECPLOT software, to draw stress contours.
c
c				               M. Eskandari/May 03,2005
c
 	write(not,10)
	write(ntm,10)
	call nopen(-nt7,'plt')
	write(nt7,100)
	write(nt7,200)
	write(nt7,300)numnp,numel
	do i=1,numnp
		write(nt7,400)coord(1,i),coord(2,i)
		do j=1,3
			write(nt7,500)stres(j,i)
		end do
	    sx=stres(1,i)
	    sy=stres(2,i)
	    txy=stres(3,i)
		smax=(sx+sy)/2+sqrt(((sx-sy)/2)**2+txy**2)
		smin=(sx+sy)/2-sqrt(((sx-sy)/2)**2+txy**2)
		write(nt7,500)smin
		write(nt7,500)smax
	end do
	do i=1,numel
		write(nt7,601)
		do j=1,4
			write(nt7,600)iele(j,i)
		end do
	end do
c
10	format(//,'             GOING TO SAVE THE TECPLOT FILE',/,
     +' File *.plt contains stress contours in TECPLOT software format')
100	format('TITLE="4-Node"')
200	format('VARIABLES="X","Y","Sxx","Syy","Sxy","Smin","Smax"')
300	format('ZONE N=',I4,',E=',I4,',F=FEPOINT ,ET=QUADRILATERAL')	
400	format(/2(F9.4,1X)\)
500	format(EN15.4,1X\)
600	format(I4\)
601	format(/\)
c
	end

c     --------------------------------------------------------------------NORM
      subroutine norm (f,nn,fmax)
      double precision f(1),fmax,term
c
      fmax=0.d0
      do 100 k=1,nn
         term=dabs(f(k))
         if (term .gt. fmax) fmax=term
  100 continue
c
      return
      end
c     --------------------------------------------------------------------MASS
      subroutine mass (ndof,swt,fmass,axgrv)
      implicit double precision (a-h,o-z)
      character*1 blnk,test
      dimension ndof(3,1),swt(1),fmass(1),fm(3),itmp(3)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      data blnk /' '/
c
c     This routine assembles the diagonal mass matrix 
c
      do 100 n=1,numnp
         idof=ndof(1,n)
         jdof=ndof(2,n)
         fmass(idof)=swt(n)
         fmass(jdof)=swt(n)
  100 continue
c
      do 110 i=1,neq
      fmass(i)=fmass(i)/axgrv
  110 continue
c
      k=0
      call find ('ADDM',k)
      if (k .eq. 0)  go to 200
         write (not,1001)
         return
  200 continue
      write (not,2001)
      n=0
  210 call free
      call freeh (' ',test,1,1)
      if (test .eq. blnk) go to 300
         call freei ('N',node,1)
         call izero (fm,6)
         call freer ('M',fm,3)
         idof=ndof(1,node)
         jdof=ndof(2,node)
         ldof=ndof(3,node)
         fmass(idof)=fmass(idof)+fm(1)
         fmass(jdof)=fmass(jdof)+fm(2)
         fmass(ldof)=fmass(ldof)+fm(3)
         n=n+1
         write (not,2002) node,fm
         itmp(1)=0
         call freei ('G',itmp,3)
         i1=itmp(1)
         if (i1 .eq. 0) go to 210
         i2=itmp(2)
         inc=itmp(3)
         do 220 i=i1,i2,inc
            idof=ndof(1,i)
            jdof=ndof(2,i)
            ldof=ndof(3,i)
            fmass(idof)=fmass(idof)+fm(1)
            fmass(jdof)=fmass(jdof)+fm(2)
            fmass(ldof)=fmass(ldof)+fm(2)
            n=n+1
            write (not,2002) i,fm
  220    continue
         go to 210
  300 continue
      write (not,3001) n
      write (ntm,3001) n
c
 1001 format (/' NO ADDED MASS TERMS DEFINED IN THE INPUT FILE')
 2001 format (/' Added masses in the system:'/' Node No.',10x,'Added ',
     +'mass_x',10x,'Added mass_y',10x,'Added mass_xy')
 2002 format (i6,12x,e13.5,9x,e13.5,10x,e13.5)
 3001 format (/' Total',i3,' nodal masess added')
c
      return
      end
C     ---------------------------------------------------------------------DEFR
      subroutine defr (last,lnew,nsize)
c
c     Defines the real storage in global integer array
c
c                                 Sudip S.B./January 2,1992/McGill
c
      nn=last/2
      mm=nn*2
      if (mm .eq. last) last=last+1
      lnew=last
      last=last+nsize
c
      return
      end
c     --------------------------------------------------------------------BAKUP
      subroutine bakup (fr,nn,key,windo)
      double precision fr(nn),windo(1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
c
c     This routine supports the backup procedure of the dead load vector and
c     mass matrix
c                              Sudip S. Bhattacharjee/January 06,1992/McGill
c
c      rewind (nfl)
c
      neqq=neq+1
      if (key .lt. 0) then
         kk=-key
      else
         kk=key
      endif
      if (kk .gt. 1) kk=numel*4+(kk-2)*neqq+1
      if (key .lt. 0) then
         call coprr (windo(kk),fr,nn)
      else
         call coprr (fr,windo(kk),nn)
      endif
c
      return
      end
c     --------------------------------------------------------------------RESID
      subroutine resid (f,fr,neq)
      double precision f(1),fr(1)
c
      do 100 i=1,neq
         fr(i)=f(i)-fr(i)
  100 continue
      return
      end
c     -------------------------------------------------------------------TERMI
      subroutine termi (llast,mtot)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     This routine terminates the executation due to the lack of memory space
c
c                                            Sudip S.B./Ecole/Jan. 14/1994
c
      write (not, 1001) llast,mtot
      write (ntm, 1001) llast,mtot
c
 1001 format (//10x,'** THE EXECUTION TERMINATED DUE TO STORAGE LIMITA',
     +'TION **',/5x,'Required storage:',i20,/5x,'Defined storage: ',i20)
c
      stop
      end
